//Lithonite Credit goes to its original author, not Drosen!!


//#Lithonite v1.3 [Chronotrigger-a-like anti obstruction walking algorithm]
//Check for obstructions and help sprite walk, execute lithonite
//Added push variable
//Fixed historical vector error.


function LithoniteEngine(objname,GIP)
{
  if(this instanceof LithoniteEngine== false) {
    return new LithoniteEngine();
  }
this.objname=objname;
this.active=true;
this.speed_normalX=1;
this.speed_normalY=1;
this.speed_dashX=1.7;
this.speed_dashY=1.7;
this.speed_crawlX=.6;
this.speed_crawlY=.6;
this.isDashing=false;
this.isCrawling=false;
this.moving=0;	//0: standing 1: walking 2: Cinematics 3: whatever
this.GIP=(typeof GIP=="string")?GIP:"";
this.idle=0; // Idle counter (not moving)
this.pushing=0;
this.GTW=IsMapEngineRunning()? GetTileWidth():16;
this.GTH=IsMapEngineRunning()? GetTileHeight():16;
this.LMaxLookupX=10;
this.LMaxLookupY=13;
this.move_x=0; this.move_y=0; //#Primary Lithonite vectors
this.hist_x=0; this.hist_y=0; //#Historical Lithonite vectors

this.counter=0; // General Purpose action counter
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.setInputPerson = function(person) {
  this.GIP=person||GetInputPerson();
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.checkDashing = function(KEY) {
 if(IsKeyPressed(KEY)) 
 {
	if(!this.isDashing)
	{
		this.isDashing=true;
		this.isCrawling=false;
		SetPersonSpeedXY(this.GIP,this.speed_dashX,this.speed_dashY);
		//SpriteSetRunning TODO!!!!!!!!!
	} 
	return true;
 }
 else if(this.isDashing)
 {
	this.isDashing=false;
	SetPersonSpeedXY(this.GIP,this.speed_normalX,this.speed_normalY); 
	//SpriteSetWalking TODO!!!!!
	return false;
 }
}

LithoniteEngine.prototype.checkCrawling = function(KEY) {
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.calcVectors = function() {
 this.move_x=0;this.move_y=0;
 if(this.moving==2) return;
 
 //if (IsJoystickOn == false)
 //{
	if(IsKeyPressed(KEY_UP)   ) {this.moving=1; --this.move_y;}
	if(IsKeyPressed(KEY_RIGHT)) {this.moving=1; ++this.move_x;}
	if(IsKeyPressed(KEY_DOWN) ) {this.moving=1; ++this.move_y;}
	if(IsKeyPressed(KEY_LEFT) ) {this.moving=1; --this.move_x;}
 //}
 //-------------------------------------
 //else
 //{
  if ( Math.round(GetJoystickX(0) ) == -1) 				  {this.moving=1; --this.move_x;}
  else if ( Math.round(GetJoystickX(0) ) == 1 )  {this.moving=1; ++this.move_x;}
 
  if ( Math.round(GetJoystickY(0) ) == -1)  				{this.moving=1; --this.move_y;}
  else if ( Math.round(GetJoystickY(0) ) == 1 ) {this.moving=1; ++this.move_y;}
 //}
 
 
 
 if(this.moving==0) {++this.idle;this.pushing=0;} else this.idle=0;
 if(this.move_x||this.move_y) {this.hist_x=this.move_x;this.hist_y=this.move_y;}
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.justStopped = function() {
  return (this.move_x==0)&&(this.move_y==0)&&(this.moving==1);
}


//----------------------------------------------------------------------------//

LithoniteEngine.prototype.deObstruct = function(person) {
 var Person=person||this.GIP; 
 if(this.moving==1 && this.active)
 {
   var $GPX = GetPersonX(Person);
   var $GPY = GetPersonY(Person);
   var $GPXX= $GPX+(this.move_x<<1);
   var $GPYY= $GPY+(this.move_y<<1);
  if(IsPersonObstructed(Person,$GPXX,$GPYY))
  {
	//Do nothing if we pressed 2 keys and it can go in one of those directions
  	if(	this.move_x && this.move_y &&
		(
			!IsPersonObstructed(Person,$GPXX,$GPY)  
		||
			!IsPersonObstructed(Person,$GPX,$GPYY)
		)
	) return false;
  else { //#1keypressed
   var $domovePOS=0; var $domoveNEG=0;
   var $dHI=0; var $dVI=0;
   var $maxlook=this.LMaxLookupY; if(this.move_x) $maxlook=this.LMaxLookupX;
   for($i=0;$i<=$maxlook;++$i)
   {
    $dHI=this.move_y*$i; $dVI=this.move_x*$i;
    $domovePOS+=!IsPersonObstructed(Person,$GPXX+$dHI,$GPYY+$dVI);
    $domoveNEG+=!IsPersonObstructed(Person,$GPXX-$dHI,$GPYY-$dVI);
   }
   if($domovePOS && ($domovePOS>=$domoveNEG) &&
	(!IsPersonObstructed(Person,$GPX+this.move_y,$GPY+this.move_x)))
   {
    SetPersonX(Person,$GPX+this.move_y);
    SetPersonY(Person,$GPY+this.move_x);
    return true;
   }
   else if($domoveNEG && 
	(!IsPersonObstructed(Person,$GPX-this.move_y,$GPY-this.move_x)))
   {
    SetPersonX(Person,$GPX-this.move_y);
    SetPersonY(Person,$GPY-this.move_x);
    return true;
   }
  }
 }//Else 1keypressed
 }//End_if:moving
 return false;
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.standStill = function() {
 if(this.moving!=2) this.moving = 0;
 if(IsInputAttached()) //Just in case a cinematic sequence is playing
 {
  SetPersonFrame(this.GIP,0);
  SetPersonDirection(this.GIP, this.getFaceDir(this.hist_x,this.hist_y));
 }
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.getFaceDir = function(x,y) {
 if((y>0)&&(x==0)) return 'south';
 if((y>0)&&(x>0)) return 'southeast';
 if((y>0)&&(x<0)) return 'southwest';
 if((y<0)&&(x==0)) return 'north';
 if((y<0)&&(x>0)) return 'northeast';
 if((y<0)&&(x<0))return 'northwest';
 if((y==0)&&(x>0)) return 'east';
 if((y==0)&&(x<0)) return 'west';
 return 'south'; //x==y==0
}


//----------------------------------------------------------------------------//

LithoniteEngine.prototype.getCommand = function(FaceOrMove,x,y) {
	if(FaceOrMove=="Face")
	{
          if((y<0)&&(x==0)) return COMMAND_FACE_NORTH;
          if((y<0)&&(x>0)) return COMMAND_FACE_NORTHEAST;
          if((y==0)&&(x>0)) return COMMAND_FACE_EAST;
          if((y>0)&&(x>0)) return COMMAND_FACE_SOUTHEAST;
          if((y>0)&&(x<0)) return COMMAND_FACE_SOUTHWEST;
          if((y==0)&&(x<0)) return COMMAND_FACE_WEST;
          if((y<0)&&(x<0)) return COMMAND_FACE_NORTHWEST;
	  return COMMAND_FACE_SOUTH;
	}
	if((y<0)&&(x==0)) return COMMAND_MOVE_NORTH;
	if((y==0)&&(x>0)) return COMMAND_MOVE_EAST;
	if((y>0)&&(x==0)) return COMMAND_MOVE_SOUTH;
	if((y==0)&&(x<0)) return COMMAND_MOVE_WEST;
	return COMMAND_WAIT;
}

//----------------------------------------------------------------------------//

LithoniteEngine.prototype.repos = function(dx,dy,person) {
  var Person=person||this.GIP;
  var $GPX = GetPersonX(Person);
  var $GPY = GetPersonY(Person);
  var $GPXX= $GPX+dx;
  var $GPYY= $GPY+dy; 
  if(!IsPersonObstructed(Person,$GPXX,$GPYY))
  {
	SetPersonX(Person,$GPXX);
	SetPersonY(Person,$GPYY);
	return true;
  }
  return false;
}	


//----------------------------------------------------------------------------//
